#ifndef KERNEL_LIST
#define KERNEL_LIST

#include "downsample_acf.h"
#include "upsample_acf.h"

KERNEL_INFO kernelInfoConcat(DOWNSAMPLE_K)(
	"apu_downsample", 2,
	   __port(__index(0),
	   __identifier(DOWNSAMPLE_KN_IN),
	          __attributes(ACF_ATTR_VEC_IN),
	          __spatial_dep(0,0,0,0),
	          __e0_data_type(d08u),
	          __e0_size(1, 1),
	          __ek_size(2, 2)),
	   __port(__index(1),
	          __identifier(DOWNSAMPLE_KN_OUT),
	          __attributes(ACF_ATTR_VEC_OUT),
	          __spatial_dep(0,0,0,0),
	          __e0_data_type(d08u),
	          __e0_size(1, 1),
	          __ek_size(1, 1))
	);
KERNEL_INFO kernelInfoConcat(UPSAMPLE_K)(
	"apu_upsample", 2,
        __port(__index(0),
               __identifier(UPSAMPLE_KN_IN),
               __attributes(ACF_ATTR_VEC_IN),
               __spatial_dep(1,1,1,1),
               __e0_data_type(d08u),
               __e0_size(1, 1),
               __ek_size(1, 1)),
        __port(__index(1),
        __identifier(UPSAMPLE_KN_OUT),
               __attributes(ACF_ATTR_VEC_OUT),
               __spatial_dep(0,0,0,0),
               __e0_data_type(d08u),
               __e0_size(1, 1),
               __ek_size(2, 2))
	);
#endif
